# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from .sddefinition import *
from .sdtype import *
from .sdapiobject import *
from .sdtype import *
from .sdapiobject import *
from .apiexception import APIException

class SDGraphDefinition(SDAPIObject):
    """
    A SDGraphDefinition contains information about a graph type in SD
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDGraphDefinition
        """
        super(SDGraphDefinition, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def sNew(id : str) -> SDGraphDefinition:
        """
        Create new SDTypeVoid

        :param id: The id of the SDGraphDefinition. It has to be unique in the application.
        """
        outSDGraphDefinition = ctypes.c_void_p()
        _res = sd.getContext().SDGraphDefinition_sNew(ctypes.create_string_buffer(id.encode('utf-8')), ctypes.byref(outSDGraphDefinition))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outSDGraphDefinition, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outSDGraphDefinition.value, ownHandle=True)

    def getId(self) -> str:
        """
        Get the identifier of the graph definition

        """
        outId = ctypes.c_char_p()
        _res = self.mAPIContext.SDGraphDefinition_getId(self.mHandle, ctypes.byref(outId))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outId.value.decode('utf-8') # type: ignore

    def addDefinition(self, sdDefinition : SDDefinition) -> None:
        """
        Add the definition the graph definition will support

        :param sdDefinition: The node definition to add
        """
        _res = self.mAPIContext.SDGraphDefinition_addDefinition(self.mHandle, sdDefinition.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def removeDefinition(self, sdDefinition : SDDefinition) -> None:
        """
        Remove the specified definition from the graph definition

        :param sdDefinition: The node definition to remove
        """
        _res = self.mAPIContext.SDGraphDefinition_removeDefinition(self.mHandle, sdDefinition.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getDefinitionFromId(self, id : str) -> Optional[SDDefinition]:
        """
        Get the SDDefinition that match the specified Id

        :param id: The id of the SDDefinition to retrieve
        """
        outSDDefinition = ctypes.c_void_p()
        _res = self.mAPIContext.SDGraphDefinition_getDefinitionFromId(self.mHandle, ctypes.create_string_buffer(id.encode('utf-8')), ctypes.byref(outSDDefinition))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDDefinition, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDDefinition.value, ownHandle=True)

    def addType(self, sdType : SDType) -> None:
        """
        Add the type the graph definition will support

        :param sdType: The type to add
        """
        _res = self.mAPIContext.SDGraphDefinition_addType(self.mHandle, sdType.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def setLabel(self, label : str) -> None:
        """
        Set the label of the graph definition

        :param label: The label of the graph definition
        """
        _res = self.mAPIContext.SDGraphDefinition_setLabel(self.mHandle, ctypes.create_string_buffer(label.encode('utf-8')))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def setIconFile(self, iconFilePath : str) -> None:
        """
        Set the icon of the graph definition from the specified file

        :param iconFilePath: The file of the icon
        """
        _res = self.mAPIContext.SDGraphDefinition_setIconFile(self.mHandle, ctypes.create_string_buffer(iconFilePath.encode('utf-8')))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

